<style>
  /* Skeleton base */
  .skeleton {
    position: relative;
    background-color: #d1d5db; /* modern gray */
    overflow: hidden;
    border-radius: 0.5rem;
  }

  /* Shimmer animation */
  .skeleton::after {
    content: '';
    position: absolute;
    top: 0;
    left: -200px;
    width: 200px;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255,255,255,0.4), transparent);
    animation: shimmer 1.5s infinite;
  }

  @keyframes shimmer {
    0% { transform: translateX(0); }
    100% { transform: translateX(100%); }
  }

  /* Full page loader */
  #loaderSkelton {
    position: fixed;
    inset: 0;
    width: 100%;
    height: 100%;
    background: #f8fafc;
    z-index: 9999;
    overflow-y: auto; /* if skeleton is tall */
  }

  /* Sidebar styling */
  .sidebar {
    min-height: 100vh;
    background-color: #f1f5f9;
    transition: transform 0.3s ease-in-out;
  }

  /* Hide sidebar on small devices */
  @media (max-width: 768px) {
    .sidebar {
      transform: translateX(-100%);
      position: absolute;
      z-index: 1000;
    }
    .sidebar.show {
      transform: translateX(0);
    }
  }

  /* Card skeletons */
  .card-skeleton {
    height: 120px;
  }

  /* Chart skeletons */
  .chart-skeleton {
    height: 200px;
  }

  /* Topbar profile circle */
  .profile-skeleton {
    width: 40px;
    height: 40px;
    border-radius: 50%;
  }
</style>

<div id="loaderSkelton">
  <div class="d-flex">

  <!-- Sidebar -->
<!-- Sidebar -->
<div class="sidebar p-3 shadow" style="width: 250px; height: 100vh; overflow-y: auto;">
  <!-- Logo -->
  <div class="skeleton mb-4" style="height: 40px; width: 160px;"></div>

  <!-- Menu Items -->
  <div class="d-flex align-items-center mb-3">
    <div class="skeleton me-2" style="width: 30px; height: 30px; border-radius: 8px;"></div>
    <div class="skeleton" style="height: 25px; width: 140px;"></div>
  </div>
  <div class="d-flex align-items-center mb-3">
    <div class="skeleton me-2" style="width: 30px; height: 30px; border-radius: 8px;"></div>
    <div class="skeleton" style="height: 25px; width: 120px;"></div>
  </div>
  <div class="d-flex align-items-center mb-3">
    <div class="skeleton me-2" style="width: 30px; height: 30px; border-radius: 8px;"></div>
    <div class="skeleton" style="height: 25px; width: 150px;"></div>
  </div>
  <div class="d-flex align-items-center mb-3">
    <div class="skeleton me-2" style="width: 30px; height: 30px; border-radius: 8px;"></div>
    <div class="skeleton" style="height: 25px; width: 110px;"></div>
  </div>
  <div class="d-flex align-items-center mb-3">
    <div class="skeleton me-2" style="width: 30px; height: 30px; border-radius: 8px;"></div>
    <div class="skeleton" style="height: 25px; width: 130px;"></div>
  </div>
  <div class="d-flex align-items-center mb-3">
    <div class="skeleton me-2" style="width: 30px; height: 30px; border-radius: 8px;"></div>
    <div class="skeleton" style="height: 25px; width: 100px;"></div>
  </div>

  <!-- Divider -->
  <div class="skeleton mb-4" style="height: 14px; width: 70%;"></div>

  <!-- More Menus -->
  <div class="d-flex align-items-center mb-3">
    <div class="skeleton me-2" style="width: 30px; height: 30px; border-radius: 8px;"></div>
    <div class="skeleton" style="height: 25px; width: 140px;"></div>
  </div>
  <div class="d-flex align-items-center mb-3">
    <div class="skeleton me-2" style="width: 30px; height: 30px; border-radius: 8px;"></div>
    <div class="skeleton" style="height: 25px; width: 160px;"></div>
  </div>
 
    <div class="d-flex align-items-center mb-3">
    <div class="skeleton me-2" style="width: 30px; height: 30px; border-radius: 8px;"></div>
    <div class="skeleton" style="height: 25px; width: 125px;"></div>
  </div>
    <div class="d-flex align-items-center mb-3">
    <div class="skeleton me-2" style="width: 30px; height: 30px; border-radius: 8px;"></div>
    <div class="skeleton" style="height: 25px; width: 135px;"></div>
  </div>
    <div class="d-flex align-items-center mb-3">
    <div class="skeleton me-2" style="width: 30px; height: 30px; border-radius: 8px;"></div>
    <div class="skeleton" style="height: 25px; width: 130px;"></div>
  </div>
    <div class="d-flex align-items-center mb-3">
    <div class="skeleton me-2" style="width: 30px; height: 30px; border-radius: 8px;"></div>
    <div class="skeleton" style="height: 25px; width: 135px;"></div>
  </div>
    <div class="d-flex align-items-center mb-3">
    <div class="skeleton me-2" style="width: 30px; height: 30px; border-radius: 8px;"></div>
    <div class="skeleton" style="height: 25px; width: 150px;"></div>
  </div>
    <div class="d-flex align-items-center mb-3">
    <div class="skeleton me-2" style="width: 30px; height: 30px; border-radius: 8px;"></div>
    <div class="skeleton" style="height: 25px; width: 145px;"></div>
  </div>
    <div class="skeleton mb-4" style="height: 14px; width: 70%;"></div>
       <div class="d-flex align-items-center mb-3">
    <div class="skeleton me-2" style="width: 30px; height: 30px; border-radius: 8px;"></div>
    <div class="skeleton" style="height: 25px; width: 135px;"></div>
  </div>
 
</div>




    <!-- Main Content -->
 <div class="flex-grow-1">

  <!-- Topbar -->
  <nav class="navbar bg-white shadow-sm px-4 py-3 d-flex justify-content-between align-items-center">
    <div class="d-flex align-items-center gap-3">
      <div class="skeleton" style="height: 35px; width: 200px;"></div>
      <div class="skeleton" style="height: 35px; width: 120px;"></div>
    </div>
    <div class="d-flex align-items-center gap-3">
      <div class="skeleton" style="height: 35px; width: 160px;"></div>
      <div class="skeleton profile-skeleton" style="height: 40px; width: 40px; border-radius: 50%;"></div>
    </div>
  </nav>

  <!-- Content -->
  <div class="p-4">

    <!-- Dashboard Cards (Stats) -->
    <div class="row mb-4">
      <div class="col-md-3 mb-3"><div class="skeleton card-skeleton" style="height: 120px;"></div></div>
      <div class="col-md-3 mb-3"><div class="skeleton card-skeleton" style="height: 120px;"></div></div>
      <div class="col-md-3 mb-3"><div class="skeleton card-skeleton" style="height: 120px;"></div></div>
      <div class="col-md-3 mb-3"><div class="skeleton card-skeleton" style="height: 120px;"></div></div>
    </div>

    <!-- Quick Stats Row -->
    <div class="row mb-4">
      <div class="col-md-2 mb-3"><div class="skeleton" style="height: 80px;"></div></div>
      <div class="col-md-2 mb-3"><div class="skeleton" style="height: 80px;"></div></div>
      <div class="col-md-2 mb-3"><div class="skeleton" style="height: 80px;"></div></div>
      <div class="col-md-2 mb-3"><div class="skeleton" style="height: 80px;"></div></div>
      <div class="col-md-2 mb-3"><div class="skeleton" style="height: 80px;"></div></div>
      <div class="col-md-2 mb-3"><div class="skeleton" style="height: 80px;"></div></div>
    </div>

    <!-- Table Skeleton -->
    <div class="card p-3 mb-4">
      <div class="skeleton mb-3" style="height: 24px; width: 25%;"></div>
      <div class="skeleton mb-2" style="height: 20px; width: 100%;"></div>
      <div class="skeleton mb-2" style="height: 20px; width: 95%;"></div>
      <div class="skeleton mb-2" style="height: 20px; width: 92%;"></div>
      <div class="skeleton mb-2" style="height: 20px; width: 97%;"></div>
      <div class="skeleton mb-2" style="height: 20px; width: 90%;"></div>

      <!-- Pagination -->
      <div class="d-flex justify-content-end mt-3">
        <div class="skeleton" style="height: 30px; width: 180px;"></div>
      </div>
    </div>

    <!-- Charts Skeleton -->
    <div class="row">
      <div class="col-md-6 mb-4">
        <div class="card p-3">
          <div class="skeleton mb-2" style="height: 20px; width: 40%;"></div>
          <div class="skeleton chart-skeleton" style="height: 220px;"></div>
        </div>
      </div>
      <div class="col-md-6 mb-4">
        <div class="card p-3">
          <div class="skeleton mb-2" style="height: 20px; width: 50%;"></div>
          <div class="skeleton chart-skeleton" style="height: 220px;"></div>
        </div>
      </div>
    </div>


  </div>
</div>

  </div>
</div>

<script>
  $(window).on('load', function(){
    $('#loaderSkelton').fadeOut(300); // smooth fade
  });
</script>
<?php /**PATH /home/nexgenweb/lms.nexgenwebhub.com/resources/views/backend/layout/loader.blade.php ENDPATH**/ ?>