
<header>
    <style>
        .clear_cache {
            background: #ffe9c9;
            /* soft peach */
            transition: 0.4s;
            border: 1px solid #ffd392
        }

        .clear_cache:hover {
            background: #ffdba5;
            /* gentle orange hover */
            border: 1px solid #ffc977
        }
    </style>
    <div class="topbar d-flex align-items-center">

        <nav class="navbar navbar-expand gap-3">
            <div class="mobile-toggle-menu"><i class='bx bx-menu'></i>
            </div>

            <div class="top-menu ms-auto d-flex align-items-center justify-content-between" style="width: 100%">
                <a href="<?php echo e(route('cache.clear')); ?>" id="clearCacheBtn"
                    class="shadow-sm d-flex align-items-center gap-2 mx-md-5 btn btn-outline-primary"
                    style="padding:4px 10px;font-size:15px;border-radius:5px">
                    <div class="menu-title">Clear Cache</div>
                </a>

                <ul class="navbar-nav align-items-center gap-1">



                    <li class="nav-item dropdown dropdown-laungauge d-none d-sm-flex visually-hidden">
                        <a class="nav-link dropdown-toggle dropdown-toggle-nocaret" href="avascript:;"
                            data-bs-toggle="dropdown"><img src="<?php echo e(asset('backend/assets/images/county/02.png')); ?>')}}"
                                width="22" alt="">
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><a class="dropdown-item d-flex align-items-center py-2" href="javascript:;"><img
                                        src="<?php echo e(asset('backend/assets/images/county/01.png')); ?>')}}" width="20"
                                        alt=""><span class="ms-2">English</span></a>
                            </li>

                        </ul>
                    </li>


                    <li class="nav-item d-none d-sm-flex">
                        <a href="<?php echo e(route('home')); ?>" target="_blank" class="btn btn-sm btn-primary">Visit Website</a>
                    </li>

                    <li class="nav-item dropdown dropdown-app visually-hidden">
                        <a class="nav-link dropdown-toggle dropdown-toggle-nocaret" data-bs-toggle="dropdown"
                            href="javascript:;"><i class='bx bx-grid-alt'></i></a>
                        <div class="dropdown-menu dropdown-menu-end p-0">
                            <div class="app-container p-2 my-2">
                                <div class="row gx-0 gy-2 row-cols-3 justify-content-center p-2">
                                    <div class="col">
                                        <a href="javascript:;">
                                            <div class="app-box text-center">
                                                <div class="app-icon">
                                                    <img src="<?php echo e(asset('backend/assets/images/app/slack.png')); ?>')}}"
                                                        width="30" alt="">
                                                </div>
                                                <div class="app-name">
                                                    <p class="mb-0 mt-1">Slack</p>
                                                </div>
                                            </div>
                                        </a>
                                    </div>

                                </div>
                                <!--end row-->

                            </div>
                        </div>
                    </li>

                    <?php
                        $notifications = DB::table('notifications')->whereIn('type', ['admin','global'])->latest()->take(10)->get();
                        $count = count($notifications);
                    ?>

                    <li class="nav-item dropdown dropdown-large">
                        <a class="nav-link dropdown-toggle dropdown-toggle-nocaret position-relative" href="#"
                            data-bs-toggle="dropdown">
                            <span class="alert-count" id="notification-count"><?php echo e(count($notifications)); ?></span>
                            <i class='bx bx-bell'></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-end">
                            <a href="javascript:;">
                                <div class="msg-header">
                                    <p class="msg-header-title">Notifications</p>
                                    

                                </div>
                            </a>
                            <div id="notifications-container" class="header-notifications-list ps">
                                <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="dropdown-item d-flex align-items-center"
                                        id="partenTrNoT_<?php echo e($notification->id); ?>"
                                        onclick="markNotificationAsRead(<?php echo e($notification->id); ?>)">

                                        <a href="<?php echo e($notification->link ?? '#'); ?>"
                                            class="flex-grow-1 text-decoration-none">
                                            <div>
                                                <h6 class="msg-name text-wrap">
                                                    <span><?php echo e($notification->title); ?></span>
                                                    <span class="msg-time float-end text-muted">
                                                        <?php echo e(\Carbon\Carbon::parse($notification->created_at)->diffForHumans()); ?>

                                                    </span>
                                                </h6>
                                                <p class="msg-info text-wrap"><?php echo e($notification->message); ?></p>
                                            </div>
                                        </a>

                                        <div class="d-flex gap-2">
                                            <button class="btn btn-danger btn-sm "
                                                data-parentid="partenTrNoT_<?php echo e($notification->id); ?>"
                                                onclick="event.stopPropagation(); deleteNotification(this,'<?php echo e(route('admin.notification.delete', $notification->id)); ?>')">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                    fill="currentColor" class="bi bi-trash3-fill" viewBox="0 0 16 16">
                                                    <path
                                                        d="M11 1.5v1h3.5a.5.5 0 0 1 0 1h-.538l-.853 10.66A2 2 0 0 1 11.115 16h-6.23a2 2 0 0 1-1.994-1.84L2.038 3.5H1.5a.5.5 0 0 1 0-1H5v-1A1.5 1.5 0 0 1 6.5 0h3A1.5 1.5 0 0 1 11 1.5m-5 0v1h4v-1a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0-.5.5M4.5 5.029l.5 8.5a.5.5 0 1 0 .998-.06l-.5-8.5a.5.5 0 1 0-.998.06m6.53-.528a.5.5 0 0 0-.528.47l-.5 8.5a.5.5 0 0 0 .998.058l.5-8.5a.5.5 0 0 0-.47-.528M8 4.5a.5.5 0 0 0-.5.5v8.5a.5.5 0 0 0 1 0V5a.5.5 0 0 0-.5-.5">
                                                    </path>
                                                </svg>
                                            </button>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </div>
                            <a href="javascript:;">
                                <div class="text-center msg-footer">
                                    <a class="btn btn-primary w-100" href="" >View All Notifications</a>
                                </div>
                            </a>
                        </div>
                    </li>


                    <li class="nav-item dropdown dropdown-large visually-hidden">
                        <a class="nav-link dropdown-toggle dropdown-toggle-nocaret position-relative" href="#"
                            role="button" data-bs-toggle="dropdown" aria-expanded="false"> <span
                                class="alert-count">8</span>
                            <i class='bx bx-shopping-bag'></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-end">
                            <a href="javascript:;">
                                <div class="msg-header">
                                    <p class="msg-header-title">My Cart</p>
                                    <p class="msg-header-badge">10 Items</p>
                                </div>
                            </a>
                            <div class="header-message-list">

                                <a class="dropdown-item" href="javascript:;">
                                    <div class="d-flex align-items-center gap-3">
                                        <div class="position-relative">
                                            <div class="cart-product rounded-circle bg-light">
                                                <img src="<?php echo e(asset('backend/assets/images/products/11.png')); ?>')}}"
                                                    class="" alt="product image">
                                            </div>
                                        </div>
                                        <div class="flex-grow-1">
                                            <h6 class="cart-product-title mb-0">Men White T-Shirt</h6>
                                            <p class="cart-product-price mb-0">1 X $29.00</p>
                                        </div>
                                        <div class="">
                                            <p class="cart-price mb-0">$250</p>
                                        </div>
                                        <div class="cart-product-cancel"><i class="bx bx-x"></i>
                                        </div>
                                    </div>
                                </a>

                            </div>
                            <a href="javascript:;">
                                <div class="text-center msg-footer">
                                    <div class="d-flex align-items-center justify-content-between mb-3">
                                        <h5 class="mb-0">Total</h5>
                                        <h5 class="mb-0 ms-auto">$489.00</h5>
                                    </div>
                                    <button class="btn btn-primary w-100">Checkout</button>
                                </div>
                            </a>
                        </div>
                    </li>



                </ul>
            </div>
            <div class="user-box dropdown px-2 px-md-3">
                <a class="d-flex align-items-center nav-link dropdown-toggle gap-3 dropdown-toggle-nocaret"
                    href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                    <img src="<?php echo e(auth()->user()->image ?? asset('backend/uploads/admin_logo.png')); ?>" width="40"
                        height="40" class="rounded-circle" />
                    <div class="user-info">
                        <p class="user-name mb-0">Admin User</p>

                    </div>
                </a>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item d-flex align-items-center"
                            href="<?php echo e(route('admin.profile.index')); ?>"><i
                                class="bx bx-user fs-5"></i><span>Profile</span></a>
                    </li>


                    <li>
                        <div class="dropdown-divider mb-0"></div>
                    </li>
                    <li>
                        <a class="dropdown-item d-flex align-items-center" href="javascript:;"
                            onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                            <i class="bx bx-log-out-circle"></i>
                            <span>
                                Logout
                            </span>

                            <!-- Hidden Logout Form -->
                            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST"
                                style="display: none;">
                                <?php echo csrf_field(); ?>
                            </form>

                        </a>
                    </li>
                </ul>
            </div>
        </nav>
    </div>
</header>



<script>
    function deleteNotification(el, destroyUrl) {
        let parentId = $(el).data('parentid');
        $.ajax({
            url: destroyUrl,
            method: 'DELETE',
            data: {
                _token: $('meta[name="csrf-token"]').attr('content'),
            },
            success: function(res) {
                if (res.status == true) {
                    $('#' + parentId).addClass('d-none');
                    let count = parseInt($("#notification-count").text());
                    if (count > 0) {
                        count--; 
                        $("#notification-count").text(count);
                    }


                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: res.message ||
                            'Something Went Wrong'
                    });
                }
            },
            error: function(xhr) {
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: xhr.responseJSON?.message ||
                        'Delete failed. Please try again.'
                });
            }

        });
    }
</script>

<script>
    // Function to toggle dark mode
    function toggleDarkMode() {
        const isDarkMode = localStorage.getItem('dark-mode') === 'true';

        if (isDarkMode) {
            // Switch to light mode
            localStorage.setItem('dark-mode', 'false');
            document.body.classList.remove('dark');
            document.querySelector("html").classList.remove('dark-theme');
            document.querySelector("html").setAttribute('data-theme', 'light');
        } else {
            // Switch to dark mode
            localStorage.setItem('dark-mode', 'true');
            document.body.classList.add('dark');
            document.querySelector("html").classList.add('dark-theme');
            document.querySelector("html").setAttribute('data-theme', 'dark');
        }

        // Reload the page to apply changes
        window.location.reload();
    }
</script>
<?php /**PATH /home/nexgenweb/lms.nexgenwebhub.com/resources/views/backend/layout/header.blade.php ENDPATH**/ ?>