<?php $__env->startSection('content'); ?>
    <!-- Hero Section with Slider -->
    <section class="relative overflow-hidden">
        <div class="mx-auto px-4 py-6" id="slider-banner-section">
            <div class="relative rounded-2xl overflow-hidden shadow-xl">
                <!-- Slider Container -->
                <div class="swiper w-full">
                    <div class="swiper-wrapper">
                        <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="swiper-slide">
                                <a href="<?php echo e($slider->link); ?>" class="block h-full">
                                    <img src="<?php echo e(asset($slider->image_url)); ?>" alt="Admission 2024-25"
                                        class="w-full h-full max-h-[500px] aspect-video object-cover">
                                </a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="hidden md:block">
                        <div
                            class="swiper-button-next !w-10 !h-10 rounded-full shrink-0 transition-all duration-300 shadow-lg">
                        </div>
                        <div
                            class="swiper-button-prev !w-10 !h-10 rounded-full shrink-0 transition-all duration-300 shadow-lg">
                        </div>
                    </div>
                    <div class="swiper-pagination !bottom-4"></div>
                </div>
            </div>
        </div>
    </section>



    <!-- Course Categories Section -->
    <section class="py-[120px] relative overflow-hidden">
        <!-- Background Pattern -->
        <div class="absolute inset-0 opacity-5">
            <div class="absolute inset-0"
                style="background-image: url('data:image/svg+xml,%3Csvg width=\'60\' height=\'60\' viewBox=\'0 0 60 60\' xmlns=\'http://www.w3.org/2000/svg\'%3E%3Cg fill=\'none\' fill-rule=\'evenodd\'%3E%3Cg fill=\'%230f766e\' fill-opacity=\'0.4\'%3E%3Cpath d=\'M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z\'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E');">
            </div>
        </div>

        <div class="container mx-auto px-4 relative z-10">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold text-gray-900 mb-4">Choose Your Learning Path</h2>
                <p class="text-lg text-gray-600 max-w-2xl mx-auto">
                    Discover diverse courses across multiple disciplines designed to help you excel in your academic and
                    admission journey.
                </p>
            </div>

            <!-- Categories Grid -->
            <div class="flex flex-wrap justify-center gap-4">
                <?php $__currentLoopData = $allCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(route('course.index', ['category' => $category->slug])); ?>"
                        class="group w-[calc(50%-1rem)] md:w-[calc(33.333%-1rem)] lg:w-[calc(16.666%-1rem)]
                  bg-white rounded-xl p-6 text-center shadow-md hover:shadow-xl
                  transition-all duration-300 transform hover:-translate-y-2 border border-gray-100">

                        <div
                            class="w-20 h-20 mx-auto mb-4 rounded-full flex items-center justify-center transition-colors duration-300">
                            <img src="<?php echo e(asset($category->icon)); ?>" alt="<?php echo e($category->name); ?>"
                                class="w-10 h-10 object-contain transition-transform duration-300 group-hover:scale-110"
                                loading="lazy">
                        </div>

                        <h3 class="font-medium text-gray-900 group-hover:text-teal-600 transition-colors duration-300">
                            <?php echo e($category->name); ?>

                        </h3>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

        </div>
    </section>

    <!-- Courses Section -->
    <section class="py-[120px] from-gray-50 to-gray-100">
        <div class="container mx-auto px-4">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold text-gray-900 mb-4">Popular Courses</h2>
                <p class="text-lg text-gray-600 max-w-2xl mx-auto">
                    Choose your course and start learning today
                </p>
            </div>

            <div class="flex flex-wrap justify-center gap-8">
                <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div
                        class="group w-[calc(100%-2rem)] sm:w-[calc(50%-2rem)] lg:w-[calc(33.333%-2rem)]
                   bg-[#15253f] rounded-xl overflow-hidden shadow-md hover:shadow-xl
                   transition-all duration-300 transform hover:-translate-y-2 border border-[#1e2a4d]">

                        <!-- Course Image -->
                        <div class="relative overflow-hidden">
                            <img src="<?php echo e(asset($course->thumbnail_url)); ?>" alt="<?php echo e($course->title); ?>"
                                class="w-full h-48 object-cover transition-transform duration-500 group-hover:scale-110">

                            <?php if($course->is_free == 1): ?>
                                <span
                                    class="absolute top-4 right-4 px-3 py-1 bg-red-600 text-white text-sm font-semibold rounded-full">
                                    <?php echo e(__('text.free')); ?>

                                </span>
                            <?php else: ?>
                                <span
                                    class="absolute top-4 right-4 px-3 py-1 bg-[#c8a050] text-[#0F172A] text-sm font-semibold rounded-full">
                                    <?php echo e($course->discount_percentage); ?>% OFF
                                </span>
                            <?php endif; ?>
                        </div>

                        <!-- Course Content -->
                        <div class="p-6">
                            <a href="<?php echo e(route('course.view', $course->slug)); ?>" class="block">
                                <h3
                                    class="text-xl font-semibold text-[#c8a050] mb-2 line-clamp-2 group-hover:text-[#fbbf24] transition-colors duration-300">
                                    <?php echo e($course->title); ?>

                                </h3>
                            </a>

                            <!-- Course Meta -->
                            <div class="flex items-center justify-between mb-4 text-sm text-[#E2E8D0]">
                                <div class="flex items-center">
                                    <?php if($course->course_type == 'Live'): ?>
                                        <img alt="live" class="w-4 h-4 mr-1"
                                            src="<?php echo e(asset('assets/icons/live-ani.svg')); ?>">
                                        <span><?php echo e(__('text.live')); ?></span>
                                    <?php else: ?>
                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 mr-1 text-red-400"
                                            viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                            stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M4 22h14a2 2 0 0 0 2-2V7l-5-5H6a2 2 0 0 0-2 2v4"></path>
                                            <path d="M14 2v4a2 2 0 0 0 2 2h4"></path>
                                            <rect width="8" height="6" x="2" y="12" rx="1"></rect>
                                            <path d="m10 15.5 4 2.5v-6l-4 2.5"></path>
                                        </svg>
                                        <span><?php echo e(__('text.recorded')); ?></span>
                                    <?php endif; ?>
                                </div>
                                <div class="flex items-center">
                                    <span><?php echo e($course->category->name); ?></span>
                                </div>
                            </div>

                            <!-- Course Stats -->
                            <div class="flex items-center justify-between mb-4 text-sm text-[#E2E8D0]">
                                <div class="flex items-center">
                                    <img src="<?php echo e(asset('assets/icons/multi-user.png')); ?>" class="w-4 h-4 mr-1"
                                        alt="Students">
                                    <span><?php echo e($course->total_enroll); ?> <?php echo e(__('text.enrolled')); ?></span>
                                </div>
                                <div class="flex items-center">
                                    <img src="<?php echo e(asset('assets/icons/video-player.svg')); ?>" class="w-4 h-4 mr-1"
                                        alt="Classes">
                                    <span><?php echo e($course->total_class); ?> <?php echo e(__('text.class')); ?></span>
                                </div>
                            </div>

                            <!-- Price & Button -->
                            <div class="flex items-center justify-between">
                                <?php if($course->is_free == 1): ?>
                                    <span class="text-xl font-bold text-red-600"><?php echo e(__('text.free')); ?></span>
                                <?php else: ?>
                                    <div>
                                        <span
                                            class="text-xl font-bold text-[#c8a050]">৳<?php echo e((float) $course->discounted_price); ?></span>
                                        <span
                                            class="text-sm text-[#E2E8D0] line-through ml-1">৳<?php echo e((float) $course->original_price); ?></span>
                                    </div>
                                <?php endif; ?>

                                <?php if($course->status === 'draft'): ?>
                                    <span
                                        class="px-3 py-1 text-yellow-600 text-sm font-semibold border border-yellow-400 rounded-lg bg-yellow-50">
                                        ⏳ <?php echo e(__('text.coming_soon')); ?>

                                    </span>
                                <?php else: ?>
                                    <a href="<?php echo e(route('course.view', $course->slug)); ?>"
                                        class="px-4 py-2 bg-[#c8a050] !text-[#0F172A] text-sm font-medium rounded-lg hover:bg-[#fbbf24] transition-colors duration-300">
                                        <?php echo e(__('text.view_details')); ?>

                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

        </div>
    </section>


    <!-- Why Learn With Us Section -->
    <section class="relative py-[120px] overflow-hidden bg-[#0F172A]">
        <div class="relative container mx-auto px-6 md:px-12 text-center">
            <h2 class="text-3xl md:text-4xl font-bold text-[#E2E8D0] mb-6">
                Why <span class="text-[#c8a050]">Students Choose Us</span>
            </h2>
            <p class="max-w-2xl mx-auto text-[#E2E8D0] text-opacity-70 mb-14">
                A smarter way to prepare for success — with interactive tools, expert guidance, and a community that grows
                with you.
            </p>

            <div class="flex flex-wrap justify-center gap-10">

                <!-- Feature -->
                <div
                    class="group relative p-8 rounded-2xl bg-[#15253f] shadow-sm hover:shadow-xl transition-all duration-300 w-[calc(100%-2rem)] sm:w-[calc(50%-2rem)] lg:w-[calc(25%-2rem)]">
                    <span
                        class="absolute inset-x-0 -top-0.5 mx-auto w-20 h-1.5 bg-[#c8a050] rounded-full opacity-0 group-hover:opacity-100 transition"></span>
                    <div class="w-16 h-16 mx-auto mb-5 rounded-full bg-[#1e2a4d] flex items-center justify-center">
                        <img src="<?php echo e(asset('assets/icons/live.webp')); ?>" alt="Live Classes" class="w-10 h-10">
                    </div>
                    <h3 class="font-semibold text-xl text-[#c8a050] mb-2">Live Expert Classes</h3>
                    <p class="text-[#E2E8D0] text-opacity-70">Learn in real-time with certified teachers and immediate doubt
                        solutions.</p>
                </div>

                <!-- Feature -->
                <div
                    class="group relative p-8 rounded-2xl bg-[#15253f] shadow-sm hover:shadow-xl transition-all duration-300 w-[calc(100%-2rem)] sm:w-[calc(50%-2rem)] lg:w-[calc(25%-2rem)]">
                    <span
                        class="absolute inset-x-0 -top-0.5 mx-auto w-20 h-1.5 bg-[#c8a050] rounded-full opacity-0 group-hover:opacity-100 transition"></span>
                    <div class="w-16 h-16 mx-auto mb-5 rounded-full bg-[#1e2a4d] flex items-center justify-center">
                        <img src="<?php echo e(asset('assets/icons/book.png')); ?>" alt="Study Materials" class="w-10 h-10">
                    </div>
                    <h3 class="font-semibold text-xl text-[#c8a050] mb-2">Pro Study Materials</h3>
                    <p class="text-[#E2E8D0] text-opacity-70">Well-structured notes and guides crafted to simplify tough
                        concepts.</p>
                </div>

                <!-- Feature -->
                <div
                    class="group relative p-8 rounded-2xl bg-[#15253f] shadow-sm hover:shadow-xl transition-all duration-300 w-[calc(100%-2rem)] sm:w-[calc(50%-2rem)] lg:w-[calc(25%-2rem)]">
                    <span
                        class="absolute inset-x-0 -top-0.5 mx-auto w-20 h-1.5 bg-[#c8a050] rounded-full opacity-0 group-hover:opacity-100 transition"></span>
                    <div class="w-16 h-16 mx-auto mb-5 rounded-full bg-[#1e2a4d] flex items-center justify-center">
                        <img src="<?php echo e(asset('assets/icons/assessment.png')); ?>" alt="Practice Tests" class="w-10 h-10">
                    </div>
                    <h3 class="font-semibold text-xl text-[#c8a050] mb-2">Smart Assessments</h3>
                    <p class="text-[#E2E8D0] text-opacity-70">Practice with timed tests and instant analytics to track your
                        growth.</p>
                </div>

                <!-- Feature -->
                <div
                    class="group relative p-8 rounded-2xl bg-[#15253f] shadow-sm hover:shadow-xl transition-all duration-300 w-[calc(100%-2rem)] sm:w-[calc(50%-2rem)] lg:w-[calc(25%-2rem)]">
                    <span
                        class="absolute inset-x-0 -top-0.5 mx-auto w-20 h-1.5 bg-[#c8a050] rounded-full opacity-0 group-hover:opacity-100 transition"></span>
                    <div class="w-16 h-16 mx-auto mb-5 rounded-full bg-[#1e2a4d] flex items-center justify-center">
                        <svg viewBox="0 0 34 35" class="w-10 h-10 text-[#c8a050]" xmlns="http://www.w3.org/2000/svg"
                            fill="currentColor">
                            <path
                                d="M9.4362 10.8332C12.1976 10.8332 14.4362 8.59467 14.4362 5.83334C14.4362 3.072 12.1976 0.833496 9.4362 0.833496C6.67477 0.833496 4.4362 3.072 4.4362 5.83334C4.4362 8.59467 6.67477 10.8332 9.4362 10.8332ZM0.269531 15.4466C0.269531 13.8193 1.58868 12.5002 3.21593 12.5002H11.1614C10.5942 13.4807 10.2695 14.6192 10.2695 15.8335C10.2695 17.8247 11.1425 19.6119 12.5265 20.8335H10.7159C8.7379 20.8335 7.05065 22.0785 6.39498 23.8275C3.89713 23.217 2.34899 21.8549 1.43762 20.3379C0.269425 18.3935 0.269516 16.3927 0.269531 16.0455V15.4466ZM23.6031 15.8335C23.6031 14.6192 23.2784 13.4807 22.7112 12.5002H30.6565C32.2837 12.5002 33.6029 13.8193 33.6029 15.4466V16.0455C33.6029 16.3927 33.603 18.3935 32.4348 20.3379C31.5234 21.8549 29.9753 23.217 27.4774 23.8275C26.8217 22.0785 25.1345 20.8335 23.1565 20.8335H21.3461C22.7302 19.6119 23.6031 17.8247 23.6031 15.8335ZM29.4362 5.83334C29.4362 8.59467 27.1976 10.8332 24.4362 10.8332C21.6748 10.8332 19.4362 8.59467 19.4362 5.83334C19.4362 3.072 21.6748 0.833496 24.4362 0.833496C27.1976 0.833496 29.4362 3.072 29.4362 5.83334ZM7.76953 25.4466C7.76953 23.8193 9.08868 22.5002 10.7159 22.5002H23.1565C24.7837 22.5002 26.1029 23.8193 26.1029 25.4466V26.0455C26.1029 26.3927 26.103 28.3935 24.9348 30.3379C23.6991 32.3946 21.2929 34.1668 16.9362 34.1668C12.5795 34.1668 10.1733 32.3946 8.93762 30.3379C7.76942 28.3935 7.76952 26.3927 7.76953 26.0455V25.4466ZM16.9362 20.8332C19.6976 20.8332 21.9362 18.5947 21.9362 15.8333C21.9362 13.072 19.6976 10.8335 16.9362 10.8335C14.1748 10.8335 11.9362 13.072 11.9362 15.8333C11.9362 18.5947 14.1748 20.8332 16.9362 20.8332Z" />
                        </svg>
                    </div>
                    <h3 class="font-semibold text-xl text-[#c8a050] mb-2">Inclusive Community</h3>
                    <p class="text-[#E2E8D0] text-opacity-70">Collaborate, share ideas, and feel motivated with peers on
                        the same journey.</p>
                </div>

            </div>
        </div>
    </section>


    <section class="py-[120px] relative overflow-hidden">
        <!-- Background Pattern -->
        <div class="absolute inset-0 opacity-10">
            <div class="absolute inset-0"
                style="background-image: url('data:image/svg+xml,%3Csvg width=\'60\' height=\'60\' viewBox=\'0 0 60 60\' xmlns=\'http://www.w3.org/2000/svg\'%3E%3Cg fill=\'none\' fill-rule=\'evenodd\'%3E%3Cg fill=\'%23ffffff\' fill-opacity=\'0.4\'%3E%3Cpath d=\'M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z\'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E');">
            </div>
        </div>


        <div class="container mx-auto px-4 relative z-10">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold mb-4">Meet Our Team</h2>
                <p class="text-lg text-gray-300 max-w-2xl mx-auto">
                    A dedicated and passionate team working together to bring you the best learning experience.
                </p>
            </div>

            <div class="flex flex-wrap justify-center gap-8">
                <?php $__empty_1 = true; $__currentLoopData = $teams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div
                        class="group w-[calc(100%-2rem)] sm:w-[calc(50%-2rem)] lg:w-[calc(25%-2rem)] text-center bg-[#15253f] rounded-xl overflow-hidden shadow-md hover:shadow-xl transition-all duration-300">

                        <!-- Profile Image Wrapper -->
                        <div class="relative overflow-hidden">
                            <img src="<?php echo e(asset('uploads/team/' . $member->image)); ?>" alt="<?php echo e($member->name); ?>"
                                class="w-full h-64 object-cover transition-transform duration-500 group-hover:scale-110">

                            <!-- Hover overlay -->
                            <div
                                class="absolute inset-0 bg-black/50 opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                            </div>

                            <!-- Social Icons -->
                            <div
                                class="absolute bottom-4 left-0 right-0 flex justify-center gap-3 opacity-0 group-hover:opacity-100 transition-all duration-300">
                                <?php if($member->social_link_1): ?>
                                    <a href="<?php echo e($member->social_link_1); ?>" target="_blank"
                                        class="w-10 h-10 rounded-full bg-[#c8a050] !text-[#0F172A] flex items-center justify-center hover:bg-[#fbbf24] hover:text-[#0F172A]">
                                        <i class="fab fa-facebook-f"></i>
                                    </a>
                                <?php endif; ?>

                                <?php if($member->social_link_2): ?>
                                    <a href="<?php echo e($member->social_link_2); ?>" target="_blank"
                                        class="w-10 h-10 rounded-full bg-[#c8a050] !text-[#0F172A] flex items-center justify-center !hover:bg-[#fbbf24] hover:text-[#0F172A]">
                                        <i class="fab fa-twitter"></i>
                                    </a>
                                <?php endif; ?>

                                <?php if($member->social_link_3): ?>
                                    <a href="<?php echo e($member->social_link_3); ?>" target="_blank"
                                        class="w-10 h-10 rounded-full bg-[#c8a050] !text-[#0F172A] flex items-center justify-center hover:bg-[#fbbf24] !hover:text-[#0F172A]">
                                        <i class="fab fa-linkedin-in"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Team Info -->
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-[#c8a050] mb-1"><?php echo e($member->name); ?></h3>
                            <p class="text-[#E2E8D0] text-opacity-80"><?php echo e($member->heading); ?></p>
                            <span class="text-[#c8a050] font-medium text-sm mt-1 block"><?php echo e($member->designation); ?></span>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <?php endif; ?>
            </div>


        </div>
    </section>


    <section class="py-[120px]">
        <div class="mx-auto px-4">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold text-gray-900 mb-4">What Our Students Say</h2>
                <p class="text-lg text-gray-600 max-w-2xl mx-auto">
                    Feedbacks from students who have transformed their learning journey with us
                </p>
            </div>

            <!-- Swiper Container -->
            <div class="swiper reviews-swiper">
                <div class="swiper-wrapper">
                    <?php
                        $testimonials = $websiteSetting->testimonials ?? [];
                    ?>
                    <!-- Slide 1 -->
                    <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="swiper-slide">
                            <div class="rounded-xl overflow-hidden shadow-lg bg-gray-50">
                                <img src="<?php echo e($img); ?>" class="w-full h-64 object-cover">
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="py-[120px] relative overflow-hidden bg-[#0F172A]">
        <div class="container mx-auto px-4 relative z-10">
            <div class="flex flex-col md:flex-row items-center gap-8 justify-center">
                <!-- Text Content -->
                <div class="flex-1 text-center md:text-left">
                    <h2 class="text-3xl md:text-4xl font-bold mb-4 text-[#c8a050]">
                        Start Learning on <?php echo e($websiteSetting->app_name); ?> Today!
                    </h2>
                    <p class="text-lg mb-6 text-[#E2E8D0] text-opacity-80">
                        Improve your skills and grow your career with professional online courses.
                    </p>
                    <a href="<?php echo e(route('course.index')); ?>"
                        class="inline-flex items-center px-6 py-3 bg-[#c8a050] !text-[#0F172A] font-medium rounded-lg hover:bg-[#fbbf24] transition-colors duration-300">
                        <?php echo e(__('menu.view_courses')); ?>

                        <svg class="w-5 h-5 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M13 7l5 5m0 0l-5 5m5-5H6"></path>
                        </svg>
                    </a>
                </div>

                <!-- Image -->
                <div class="flex-shrink-0">
                    <div class="bg-[#15253f] p-4 rounded-xl shadow-2xl">
                        <img src="<?php echo e(asset('assets/images/undraw_problem-solving_1kpx.svg')); ?>" alt="explore"
                            class="w-full max-w-md rounded-lg" />
                    </div>
                </div>
            </div>
        </div>
    </section>


    <!-- Social Connect Section -->
    


    <?php $__env->startPush('js'); ?>
        <script>
            new Swiper('.swiper', {
                loop: true,
                autoplay: {
                    delay: 5000,
                    disableOnInteraction: false,
                },
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev',
                },
                pagination: {
                    el: '.swiper-pagination',
                    clickable: true,
                },
            });

            new Swiper('.reviews-swiper', {
                loop: true,
                speed: 3000, // total time to scroll one loop (adjust to control speed)
                slidesPerView: 'auto', // show multiple slides depending on width
                spaceBetween: 20,
                freeMode: true, // allow continuous scroll without snapping
                autoplay: {
                    delay: 0, // no delay between slides
                    disableOnInteraction: false, // keep autoplay even if user interacts
                },
                grabCursor: true, // optional: shows grab cursor
                breakpoints: {
                    768: {
                        slidesPerView: 2
                    },
                    1024: {
                        slidesPerView: 4
                    },
                },
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nexgenweb/lms.nexgenwebhub.com/resources/views/page/home.blade.php ENDPATH**/ ?>