<?php $__env->startSection('content'); ?>
    <div class="page-content">

        <!-- Filter Dropdown -->
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0">LMS Dashboard Overview</h4>

        </div>

        <div id="stats-container" class="row row-cols-1 row-cols-md-2 row-cols-lg-4 g-3">

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users')): ?>
                <div class="col">
                    <div class="card radius-10 status-card">
                        <div class="card-body d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Total Students</p>
                                <h4 class="my-1"><?php echo e($totalStudent); ?></h4>
                            </div>
                            <div class="widgets-icons rounded-circle text-white ms-auto bg-primary">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"
                                    fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                    stroke-linejoin="round" class="lucide lucide-users" aria-hidden="true">
                                    <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"></path>
                                    <path d="M16 3.128a4 4 0 0 1 0 7.744"></path>
                                    <path d="M22 21v-2a4 4 0 0 0-3-3.87"></path>
                                    <circle cx="9" cy="7" r="4"></circle>
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('courses')): ?>
                <div class="col">
                    <div class="card radius-10 status-card">
                        <div class="card-body d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Total Courses</p>
                                <h4 class="my-1"><?php echo e($totalCourse); ?></h4>
                            </div>
                            <div class="widgets-icons rounded-circle text-white ms-auto bg-success">
                                <i class="bi bi-journal-bookmark-fill"></i>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('instructor')): ?>
                <div class="col">
                    <div class="card radius-10 status-card">
                        <div class="card-body d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Active Instructors</p>
                                <h4 class="my-1"><?php echo e($instructors); ?></h4>
                            </div>
                            <div class="widgets-icons rounded-circle text-white ms-auto bg-warning">
                                <i class="bi bi-person-badge-fill"></i>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('enrollments')): ?>
                <div class="col">
                    <div class="card radius-10 status-card">
                        <div class="card-body d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Enrollments</p>
                                <h4 class="my-1"><?php echo e($totalEnrollment); ?></h4>
                            </div>
                            <div class="widgets-icons rounded-circle text-white ms-auto bg-info">
                                <i class="bi bi-card-checklist"></i>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <!-- End Stats Cards -->

        <!-- Charts -->
        <div class="row mt-4">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('enrollments')): ?>
                <div class="col-12 col-lg-7">
                    <div class="card radius-10 p-0">
                        <div class="card-body">
                            <div class="card-header d-flex align-items-center gap-2 mb-2">
                                <div style="background-color: #dbeafe; color: #2563eb; width: 40px; height: 40px;"
                                    class="rounded-circle d-flex align-items-center justify-content-center">
                                    <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 24 24"
                                        style="width: 18px; height: 18px;" xmlns="http://www.w3.org/2000/svg">
                                        <path fill="none" d="M0 0h24v24H0z"></path>
                                        <path
                                            d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM5 19V5h6v14H5zm14 0h-6v-7h6v7zm0-9h-6V5h6v5z">
                                        </path>
                                    </svg>

                                </div>


                                <h5 class="mb-0">Enrollment Growth </h5>
                            </div>
                            <div id="enrollmentChart"></div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('courses')): ?>
                <div class="col-12 col-lg-5">
                    <div class="card radius-10 p-0">
                        <div class="card-body">
                            <div class="card-header d-flex align-items-center gap-2 mb-2">
                                <div style="background-color: #fff3e5; color: #ff9925; width: 40px; height: 40px;"
                                    class="rounded-circle d-flex align-items-center justify-content-center">
                                    <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 24 24"
                                        style="width: 18px; height: 18px;" xmlns="http://www.w3.org/2000/svg">
                                        <path fill="none" d="M0 0h24v24H0z"></path>
                                        <path
                                            d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM5 19V5h6v14H5zm14 0h-6v-7h6v7zm0-9h-6V5h6v5z">
                                        </path>
                                    </svg>

                                </div>


                                <h5 class="mb-0">Top 5 Courses</h5>
                            </div>
                            <div id="topCoursesChart"></div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <!-- More Charts -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('analytics')): ?>
            <div class="row mt-4">
                <div class="col-12 ">
                    <div class="card radius-10 p-0">
                        <div class="card-body">
                            <div class="card-header d-flex align-items-center gap-2 mb-2">
                                <div style="background-color: #e8f9ef; color: #10e86a; width: 40px; height: 40px;"
                                    class="rounded-circle d-flex align-items-center justify-content-center">
                                    <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 24 24"
                                        style="width: 18px; height: 18px;" xmlns="http://www.w3.org/2000/svg">
                                        <path fill="none" d="M0 0h24v24H0z"></path>
                                        <path
                                            d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM5 19V5h6v14H5zm14 0h-6v-7h6v7zm0-9h-6V5h6v5z">
                                        </path>
                                    </svg>

                                </div>


                                <h5 class="mb-0">Revenue Growth</h5>
                            </div>

                            <div id="revenueChart"></div>
                        </div>
                    </div>
                </div>

            </div>
        <?php endif; ?>

        <!-- Recent Updates -->
        <div class="row mt-4">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('enrollments')): ?>
                <div class="col-12 col-lg-6">
                    <div class="card radius-10">
                        <div class="card-body">
                            <h5 class="mb-3">Recent Enrollments </h5>
                            <ul class="list-group">
                                <?php $__empty_1 = true; $__currentLoopData = $recentEnrollments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enroll): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <li class="list-group-item">
                                        <?php echo e($enroll->user->name); ?> enrolled in <?php echo e($enroll->course->title); ?>

                                        (<?php echo e($enroll->created_at->diffForHumans()); ?>)
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <li class="list-group-item">No recent enrollments.</li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>

                </div>
            <?php endif; ?>

            <div class="col-12 col-lg-6">
                <div class="card radius-10">
                    <div class="card-body">
                        <h5 class="mb-3">Recent Notifications</h5>
                        <ul class="list-group">
                            <?php $__empty_1 = true; $__currentLoopData = $recentNotifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notify): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <li class="list-group-item">
                                    <?php echo e($notify->message); ?> (<?php echo e($notify->created_at->diffForHumans()); ?>)
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <li class="list-group-item">No notifications.</li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            // Enrollment Growth Chart
            var enrollmentOptions = {
                chart: {
                    type: 'area',
                    height: 300
                },
                series: [{
                    name: 'Earnings',
                    data: <?php echo json_encode($enrollmentTotal, 15, 512) ?>
                }],
                xaxis: {
                    categories: <?php echo json_encode($enrollmentLabels, 15, 512) ?>,
                    title: {
                        text: 'Day Of The Week'
                    }
                },
                stroke: {
                    curve: 'smooth'
                },
                fill: {
                    type: 'gradient',
                    gradient: {
                        shadeIntensity: 1,
                        opacityFrom: 0.7,
                        opacityTo: 0.2,
                        stops: [0, 90, 100]
                    }
                },
                yaxis: {
                    title: {
                        text: 'Count'
                    }
                },
                tooltip: {
                    y: {
                        formatter: function(val) {
                            return "৳" + val;
                        }
                    }
                }
            };
            var enrollmentChart = new ApexCharts(document.querySelector("#enrollmentChart"), enrollmentOptions);
            enrollmentChart.render();


            // Top 5 Courses Chart
            var topCoursesOptions = {
                chart: {
                    type: 'bar',
                    height: 300,
                    toolbar: {
                        show: false
                    }
                },
                series: [{
                    name: 'Enrollments',
                    data: <?php echo json_encode($courseTotals, 15, 512) ?>
                }],
                plotOptions: {
                    bar: {
                        horizontal: true, // horizontal bars
                        barHeight: '50%',
                        borderRadius: 6
                    }
                },
                dataLabels: {
                    enabled: true,
                    style: {
                        colors: ['#fff']
                    }
                },
                xaxis: {
                    title: {
                        text: 'Last 7 Days'
                    },
                    labels: {
                        show: true,
                        style: {
                            fontSize: '12px'
                        }
                    }
                },
                yaxis: {
                    categories: <?php echo json_encode($courseNames, 15, 512) ?>, // course names on Y-axis
                    labels: {
                        show: true,
                        style: {
                            fontSize: '12px'
                        }
                    }
                },
                tooltip: {
                    theme: 'light',
                    y: {
                        formatter: function(val, {
                            seriesIndex,
                            dataPointIndex,
                            w
                        }) {
                            // Show course name + number of students in tooltip
                            var courseName = w.config.yaxis[0].categories[dataPointIndex];
                            return courseName + ": " + val + " Students";
                        }
                    }
                }
            };

            var topCoursesChart = new ApexCharts(document.querySelector("#topCoursesChart"), topCoursesOptions);
            topCoursesChart.render();


            var revenueOptions = {
                chart: {
                    type: 'line',
                    height: 320,
                    toolbar: {
                        show: false
                    }
                },
                series: [{
                    name: 'Revenue',
                    data: <?php echo json_encode($revenueTotals, 15, 512) ?>
                }],
                xaxis: {
                    categories: <?php echo json_encode($revenueLabels, 15, 512) ?>,
                    title: {
                        text: 'Day of the Week'
                    }
                },
                yaxis: {
                    title: {
                        text: 'Revenue (৳)'
                    }
                },
                stroke: {
                    curve: 'smooth'
                },
                colors: ['#28a745'],
                markers: {
                    size: 5
                },
                tooltip: {
                    theme: 'light',
                    y: {
                        formatter: val => "৳" + val.toFixed(2)
                    }
                }
            };
            new ApexCharts(document.querySelector("#revenueChart"), revenueOptions).render();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nexgenweb/lms.nexgenwebhub.com/resources/views/backend/page/dashboard.blade.php ENDPATH**/ ?>