<?php ($hideLayout = true); ?>

<?php $__env->startSection('content'); ?>
<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">

	<title><?php echo e(config('app.name')); ?> | Login</title>

	<style>
		.wrapper {
			min-height: 100vh;
			display: flex;
			justify-content: center;
			align-items: center;
			padding: 30px;
		}

		.login-card {
			width: 100%;
			max-width: 450px;
			background: white;
			border-radius: 18px;
			padding: 40px 30px;
			text-align: center;
			box-shadow: 0 10px 45px rgba(0, 0, 0, 0.08);
		}

		.logo {
			width: 90px;
			margin-bottom: 10px;
		}

		.title {
			font-size: 27px;
			font-weight: 800;
			color: var(--color-primary);
		}

		label {
			display: block;
			text-align: left;
			font-weight: 600;
			font-size: 14px;
			color: var(--color-primary);
			margin-top: 14px;
			margin-bottom: 6px;
		}

		.input {
			width: 100%;
			padding: 13px 14px;
			border: 1px solid #cbd5e1;
			border-radius: 10px;
			background: #f8fafc;
			font-size: 14px;
			color: var(--color-primary);
		}

		.input:focus {
			border-color: var(--color-primary);
			outline: none;
			box-shadow: 0 0 0 3px rgba(15, 118, 110, 0.2);
		}

		.error-box {
			background: #ffeef2;
			color: var(--color-error);
			font-size: 13px;
			padding: 10px 12px;
			border-radius: 8px;
			margin-top: 12px;
			text-align: left;
			border: 1px solid #fecdd3;
		}

		.password-wrap {
			position: relative;
		}

		.toggle-password {
			position: absolute;
			right: 15px;
			top: 50%;
			transform: translateY(-50%);
			cursor: pointer;
			color: var(--color-light);
		}

		.btn {
			width: 100%;
			margin-top: 25px;
			padding: 15px;
			font-size: 16px;
			font-weight: 700;
			background: var(--color-primary);
			color: white;
			border: none;
			border-radius: 10px;
			cursor: pointer;
			transition: 0.3s;
		}

		.btn:hover {
			background: var(--color-primary-dark);
			transform: translateY(-2px);
		}

		.links {
			font-size: 14px;
			margin-top: 15px;
			color: var(--color-light);
		}

		.links a {
			color: var(--color-primary);
			font-weight: 600;
			text-decoration: none;
		}

		.links a:hover {
			text-decoration: underline;
		}
	</style>
</head>

<body>

	<div class="wrapper">

		<div class="login-card">

			<!-- Logo -->
            <div class="text-center mb-6">
                <a href="/">
                    <img src="<?php echo e(asset($websiteSetting->logo)); ?>" class="h-14 mx-auto" alt="Logo">
                </a>
            </div>

			<h2 class="title">Sign In</h2>

			<?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
			<div class="error-box">
				<i class="fa-solid fa-circle-exclamation"></i>
				Invalid login credentials. Please try again.
			</div>
			<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

			<form method="POST" action="<?php echo e(route('login')); ?>">
				<?php echo csrf_field(); ?>

				<label>Email or Phone</label>
				<input id="email" type="text" name="email" value="<?php echo e(old('email')); ?>" required autocomplete="username"
					class="input" placeholder="Enter your email or phone">

				<label>Password</label>
				<div class="password-wrap">
					<input id="password" type="password" name="password" required autocomplete="current-password"
						class="input" placeholder="Enter your password">
					<i class="fa-regular fa-eye toggle-password" onclick="togglePassword()"></i>
				</div>

				<div style="margin-top:10px; text-align:right;">
					<?php if(Route::has('password.request')): ?>
					<a href="<?php echo e(route('password.request')); ?>" style="color:var(--color-primary);font-size:13px;">Forgot Password?</a>
					<?php endif; ?>
				</div>

				<button type="submit" class="btn">Sign In</button>
                
                <?php echo $__env->make('include.social-login', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
			</form>

			<p class="links">
				Don't have an account?
				<a href="/register">Sign Up</a>
			</p>

		</div>

	</div>

	<script>
		function togglePassword() {
			let field = document.getElementById("password");
			field.type = field.type === "password" ? "text" : "password";
		}
	</script>

</body>

</html>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nexgenweb/lms.nexgenwebhub.com/resources/views/auth/login.blade.php ENDPATH**/ ?>